#version 140
#extension GL_EXT_gpu_shader4 : enable
//Waves and InterferenceMod01.fsh by hhhzzzsss
//
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.666  //0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415926535897932384

void sinFunc3D(vec3 p, float freq, float amp, float phase, out float f, out vec3 df) {
    float m = length(p.xz);
    f = p.y-cos(freq*(m-phase))*amp*min(1.0, 5./m);
    df.y = 1.0;
    if (m == 0.0) {
        df.x = 0.0;
        df.z = 0.0;
    }
    else {
        df.x = p.x/m;
        df.z = p.z/m;
        df.xz *= freq*sin(freq*(m-phase))*amp*min(1.0, 5./m);
    }
}

float map(vec3 p) {
    vec3 p1 = p-vec3(-5.0*PI,0.0,0.0);
    vec3 p2 = p-vec3(5.0*PI,0.0,0.0);
    float f1, f2;
    vec3 df1, df2;
    sinFunc3D(p1, 1.0, 2.0, 10.0*iTime, f1, df1);
    sinFunc3D(p2, 1.0, 2.0, 10.0*iTime, f2, df2);
    return (f1+f2)/length(df1+df2)/1.5;
}

vec3 getNorm(vec3 p) {
    vec2 e = vec2(0.0, 0.001);
    vec3 n;
    n.x = map(p+e.yxx) - map(p-e.yxx);
    n.y = map(p+e.xyx) - map(p-e.xyx);
    n.z = map(p+e.xxy) - map(p-e.xxy);
    return normalize(n);
}

float trace(vec3 ro, vec3 rd) {
    float t = 0.001;
    for (int i=0; i<1000; i++) {
        float h = map(ro+t*rd);
        if (abs(h)<0.0001*t)
            return t;
        t += 1.0*h;
        if (t>1024.0) return -1.0;
    }
}

float softShadow(vec3 ro, vec3 rd) {
    float sha = 1.0;
    float t = 0.01;
    for (int i=0; i<256; i++) {
    	float h = map(ro+t*rd);
        sha = min(sha, 2.0*h/t);
        t += 1.0*clamp(h,0.02,0.20);
        if (t>16.0) break;
    }
    sha = clamp(sha, 0.0, 1.0);
    return sha*sha*(3.0-2.0*sha);
}

mat2 rotMat(float theta) {
    return mat2(cos(theta), sin(theta), -sin(theta), cos(theta));
}

float fresnel(vec3 inc, vec3 nor, float ior) {
    float cosi = clamp(-1., 1., dot(inc, nor));
    float n1, n2;
    if (cosi < 0.0) {
        n1 = 1.;
        n2 = ior;
        cosi = -cosi;
    }
    else {
        n1 = ior;
        n2 = 1.;
    }
    float sint = n1/n2 * sqrt(max(0., 1.-cosi*cosi));
    if (sint>=1.0) {
        return 1.0;
    }
    else {
        float cost = sqrt(max(0., 1.-sint*sint));
        float Rs = ((n1 * cosi) - (n2 * cost)) / ((n1 * cosi) + (n2 * cost));
        float Rp = ((n2 * cosi) - (n1 * cost)) / ((n2 * cosi) + (n1 * cost));
        return (Rs * Rs + Rp * Rp) / 2.;
    }
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (2.*gl_FragCoord.xy - iResolution.xy) / iResolution.y;
    vec3 ro = vec3(0.0,20.0,-20.0);
    vec3 rd = normalize(vec3(uv, 1.));
    rd.zy = rotMat(-0.8) * rd.zy;
    
    vec3 lig = normalize(vec3(0.5, 1.0, -0.5));
    
    float t = trace(ro,rd);
    
    vec3 skyCol = vec3(0.9,1.0,1.2);
    float waterDepth = 2.0;
    vec3 col;
    if (t>=0.0) {
    	vec3 pos = ro + t*rd;
    	vec3 nor = getNorm(pos);
        //float lig1 = max(dot(nor,lig),0.0);// * softShadow(pos,lig);
        //float sky = 0.5 + 0.5*nor.y;
        float spec = max(0.0, dot(reflect(rd, nor), lig));
        float refl = fresnel(rd, nor, 1.33);
        float refr = 1.0-refl;
        vec3 refVec = refract(rd, nor, 1.0/1.33);
        vec2 refFloorPos = refVec.xz / refVec.y * (pos.y+waterDepth) + pos.xz;
        
        //just to make sure floor doesn't clip into water surface. There will be obvious artifacts if it does.
        if (pos.y+waterDepth<0.0) refFloorPos = vec2(0.0);
        
        spec = pow(spec, 50.0);
        //col = vec3(0.0);
        //col += vec3(0.6,0.6,0.5) * lig1;
        //col += vec3(0.15,0.2,0.3) * sky;
        //col *= vec3(0.2,0.26,0.3);
        col += 1.0*texture2D(iChannel0, refFloorPos*0.03).xyz*0.9;
        col += vec3(spec);
        col *= refr;
        col += refl*skyCol;
    }
    else {
        col = skyCol;
    }
    
    col = pow(col,vec3(0.45));
    
    gl_FragColor = vec4(col, 1.0);
}




